<?php
/**
 * Admin Page Template - MisterTranslate v4.2.0
 * 
 * New features:
 * - Cost estimation
 * - Content preview
 * - Multiple language selection
 * - Draft/Publish options
 * - Source language detection
 * - Outdated translations check
 * - Glossary management
 */

if (!defined('ABSPATH')) {
    exit;
}

$languages = $this->get_supported_languages();
$multilingual_plugin = $this->detect_multilingual_plugin();
$multilingual_languages = $this->get_multilingual_languages();
$wc_active = $this->is_woocommerce_active();

// Check for quick translate from posts list
$quick_translate_id = isset($_GET['translate_id']) ? intval($_GET['translate_id']) : 0;
$quick_translate_type = isset($_GET['type']) ? sanitize_text_field($_GET['type']) : 'page';
?>
<div class="wrap mtp-wrap">
    <h1><span class="dashicons dashicons-translation"></span> MisterTranslate <small style="font-size:12px;color:#888;">v4.2</small></h1>
    
    <!-- Zero Balance Alert -->
    <div class="mtp-zero-balance-alert" id="mtp-zero-balance-alert" style="display:none;">
        <span class="dashicons dashicons-warning"></span>
        <div class="mtp-zero-balance-text">
            <strong>You have no words available.</strong>
            <a href="<?php echo admin_url('admin.php?page=mistertranslate-settings#mtp-how-to-buy'); ?>">Learn how to purchase words &rarr;</a>
        </div>
    </div>
    
    <!-- Balance Bar -->
    <div class="mtp-balance-bar">
        <div class="mtp-balance-info">
            <span class="mtp-balance-label">Available words:</span>
            <span class="mtp-balance-range">
                Between <strong id="mtp-words-min">--</strong> and <strong id="mtp-words-max">--</strong>
            </span>
            <small style="opacity:0.8;">(<span id="mtp-tokens-exact">--</span> tokens)</small>
        </div>
        <button type="button" class="button" id="mtp-refresh-balance">
            <span class="dashicons dashicons-update"></span> Refresh
        </button>
    </div>
    
    <!-- Quick Translate Notice -->
    <?php if ($quick_translate_id): 
        $quick_post = get_post($quick_translate_id);
        if ($quick_post):
    ?>
    <div class="mtp-quick-translate-notice">
        <span class="dashicons dashicons-arrow-right-alt"></span>
        Ready to translate: <strong><?php echo esc_html($quick_post->post_title); ?></strong>
        <small>(<?php echo esc_html($quick_translate_type); ?>)</small>
    </div>
    <?php endif; endif; ?>
    
    <!-- Main Panel -->
    <div class="mtp-main-panel">
        
        <!-- Tabs -->
        <div class="mtp-tabs">
            <button type="button" class="mtp-tab active" data-tab="pages">
                <span class="dashicons dashicons-admin-page"></span> Pages & Posts
            </button>
            <?php if ($wc_active): ?>
            <button type="button" class="mtp-tab" data-tab="products">
                <span class="dashicons dashicons-cart"></span> Products
            </button>
            <button type="button" class="mtp-tab" data-tab="categories">
                <span class="dashicons dashicons-category"></span> Categories
            </button>
            <button type="button" class="mtp-tab" data-tab="attributes">
                <span class="dashicons dashicons-tag"></span> Attributes
            </button>
            <?php endif; ?>
            <button type="button" class="mtp-tab" data-tab="outdated">
                <span class="dashicons dashicons-update"></span> Updates
            </button>
            <button type="button" class="mtp-tab" data-tab="glossary">
                <span class="dashicons dashicons-book-alt"></span> Glossary
            </button>
        </div>
        
        <!-- Tab Content: Pages -->
        <div class="mtp-tab-content active" id="tab-pages">
            <div class="mtp-form-section">
                <h2>1. Select pages to translate</h2>
                <div class="mtp-search-box">
                    <input type="text" id="mtp-page-search" placeholder="Search pages..." class="regular-text" data-type="page">
                    <span class="spinner" id="mtp-page-spinner"></span>
                </div>
                <button type="button" class="button mtp-load-all" data-type="page">
                    <span class="dashicons dashicons-admin-page"></span> Load all
                </button>
                <div class="mtp-item-list" id="mtp-page-list">
                    <p class="mtp-hint">Type to search or load all pages...</p>
                </div>
            </div>
        </div>
        
        <?php if ($wc_active): ?>
        <!-- Tab Content: Products -->
        <div class="mtp-tab-content" id="tab-products">
            <div class="mtp-form-section">
                <h2>1. Select products to translate</h2>
                <div class="mtp-search-box">
                    <input type="text" id="mtp-product-search" placeholder="Search products..." class="regular-text" data-type="product">
                    <span class="spinner" id="mtp-product-spinner"></span>
                </div>
                <button type="button" class="button mtp-load-all" data-type="product">
                    <span class="dashicons dashicons-cart"></span> Load all
                </button>
                <div class="mtp-item-list" id="mtp-product-list">
                    <p class="mtp-hint">Type to search or load all products...</p>
                </div>
            </div>
        </div>
        
        <!-- Tab Content: Categories -->
        <div class="mtp-tab-content" id="tab-categories">
            <div class="mtp-form-section">
                <h2>1. Select categories to translate</h2>
                <div class="mtp-search-box">
                    <input type="text" id="mtp-category-search" placeholder="Search categories..." class="regular-text" data-type="product_cat">
                    <span class="spinner" id="mtp-category-spinner"></span>
                </div>
                <button type="button" class="button mtp-load-all" data-type="product_cat">
                    <span class="dashicons dashicons-category"></span> Load all
                </button>
                <div class="mtp-item-list" id="mtp-category-list">
                    <p class="mtp-hint">Type to search or load all categories...</p>
                </div>
            </div>
        </div>
        
        <!-- Tab Content: Attributes -->
        <div class="mtp-tab-content" id="tab-attributes">
            <div class="mtp-form-section">
                <h2>1. Select attribute terms to translate</h2>
                <div class="mtp-search-box">
                    <input type="text" id="mtp-attribute-search" placeholder="Search attribute terms..." class="regular-text" data-type="attribute">
                    <span class="spinner" id="mtp-attribute-spinner"></span>
                </div>
                <button type="button" class="button mtp-load-all" data-type="attribute">
                    <span class="dashicons dashicons-tag"></span> Load all
                </button>
                <div class="mtp-item-list" id="mtp-attribute-list">
                    <p class="mtp-hint">Type to search or load all attribute terms...</p>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Tab Content: Outdated Translations -->
        <div class="mtp-tab-content" id="tab-outdated">
            <div class="mtp-form-section">
                <h2><span class="dashicons dashicons-update"></span> Translations needing update</h2>
                <p class="description">These translations may be outdated because the original content has changed.</p>
                <button type="button" class="button" id="mtp-check-outdated">
                    <span class="dashicons dashicons-search"></span> Check for updates
                </button>
                <div class="mtp-outdated-list" id="mtp-outdated-list">
                    <p class="mtp-hint">Click "Check for updates" to scan for outdated translations...</p>
                </div>
            </div>
        </div>
        
        <!-- Tab Content: Glossary -->
        <div class="mtp-tab-content" id="tab-glossary">
            <div class="mtp-form-section">
                <h2><span class="dashicons dashicons-book-alt"></span> Translation Glossary</h2>
                <p class="description">Define terms that should never be translated (brand names) or always be translated in a specific way.</p>
                
                <div class="mtp-glossary-sections">
                    <!-- Never Translate -->
                    <div class="mtp-glossary-section">
                        <h3>Never Translate</h3>
                        <p class="description">These terms will remain unchanged in all translations.</p>
                        <div class="mtp-glossary-input">
                            <input type="text" id="mtp-never-term" placeholder="Enter term..." class="regular-text">
                            <button type="button" class="button" id="mtp-add-never">
                                <span class="dashicons dashicons-plus"></span> Add
                            </button>
                        </div>
                        <div class="mtp-glossary-list" id="mtp-never-list">
                            <p class="mtp-hint">No terms added yet</p>
                        </div>
                    </div>
                    
                    <!-- Specific Translations -->
                    <div class="mtp-glossary-section">
                        <h3>Specific Translations</h3>
                        <p class="description">Force specific translations for certain terms.</p>
                        <div class="mtp-glossary-input mtp-specific-input">
                            <input type="text" id="mtp-specific-term" placeholder="Original term..." class="regular-text">
                            <input type="text" id="mtp-specific-translation" placeholder="Translation..." class="regular-text">
                            <button type="button" class="button" id="mtp-add-specific">
                                <span class="dashicons dashicons-plus"></span> Add
                            </button>
                        </div>
                        <div class="mtp-glossary-list" id="mtp-specific-list">
                            <p class="mtp-hint">No translations added yet</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Selection Summary -->
        <div class="mtp-selection-summary" id="mtp-selection-summary" style="display:none;">
            <span id="mtp-selected-count">0</span> selected
            <span class="mtp-source-lang" id="mtp-source-lang-display"></span>
            <button type="button" class="button-link" id="mtp-preview-btn">Preview</button>
            <button type="button" class="button-link" id="mtp-clear-all">Clear</button>
        </div>
        
        <!-- Cost Estimation -->
        <div class="mtp-cost-estimate" id="mtp-cost-estimate" style="display:none;">
            <div class="mtp-estimate-icon"><span class="dashicons dashicons-chart-bar"></span></div>
            <div class="mtp-estimate-text">
                Estimated cost: <strong><span id="mtp-estimate-words">0</span> words</strong>
                <small>(<span id="mtp-estimate-tokens-min">0</span> - <span id="mtp-estimate-tokens-max">0</span> tokens)</small>
            </div>
        </div>
        
        <!-- Step 2: Languages (Multiple Selection) -->
        <div class="mtp-form-section" id="mtp-languages-section">
            <h2>2. Select target language(s)</h2>
            <p class="description">Select one or more languages to translate to.</p>
            <div class="mtp-language-checkboxes" id="mtp-language-checkboxes">
                <?php foreach ($languages as $code => $name): ?>
                <label class="mtp-lang-checkbox">
                    <input type="checkbox" name="mtp_target_langs[]" value="<?php echo esc_attr($code); ?>">
                    <span class="mtp-lang-label"><?php echo esc_html($name); ?></span>
                </label>
                <?php endforeach; ?>
            </div>
            <div class="mtp-lang-actions">
                <button type="button" class="button-link" id="mtp-select-all-langs">Select all</button>
                <button type="button" class="button-link" id="mtp-clear-all-langs">Clear all</button>
            </div>
        </div>
        
        <!-- Step 3: Link (if Polylang/WPML available) -->
        <?php if ($multilingual_plugin !== 'none' && !empty($multilingual_languages)): ?>
        <div class="mtp-form-section mtp-multilingual-section">
            <h2>3. Link with <?php echo $multilingual_plugin === 'polylang' ? 'Polylang' : 'WPML'; ?></h2>
            <select id="mtp-link-lang" class="mtp-select">
                <option value="">-- Do not link --</option>
                <?php foreach ($multilingual_languages as $code => $name): ?>
                <option value="<?php echo esc_attr($code); ?>"><?php echo esc_html($name); ?> (<?php echo $code; ?>)</option>
                <?php endforeach; ?>
            </select>
        </div>
        <?php else: ?>
        <input type="hidden" id="mtp-link-lang" value="">
        <?php endif; ?>
        
        <!-- Translate Buttons -->
        <div class="mtp-form-section mtp-translate-section">
            <button type="button" class="button button-primary button-hero" id="mtp-translate-btn" disabled>
                <span class="dashicons dashicons-translation"></span> Translate
            </button>
            <button type="button" class="button button-secondary button-hero" id="mtp-translate-draft-btn" disabled>
                <span class="dashicons dashicons-edit"></span> Translate as Draft
            </button>
        </div>
    </div>
    
    <!-- Preview Modal -->
    <div class="mtp-modal" id="mtp-preview-modal" style="display:none;">
        <div class="mtp-modal-content mtp-preview-content">
            <span class="mtp-modal-close" id="mtp-close-preview">&times;</span>
            <h3>Content Preview</h3>
            <div id="mtp-preview-body">
                <div class="mtp-preview-item">
                    <strong>Title:</strong> <span id="mtp-preview-title"></span>
                </div>
                <div class="mtp-preview-item">
                    <strong>Words:</strong> <span id="mtp-preview-words"></span>
                </div>
                <div class="mtp-preview-item">
                    <strong>Source Language:</strong> <span id="mtp-preview-lang"></span>
                    <small id="mtp-preview-confidence"></small>
                </div>
                <div class="mtp-preview-item">
                    <strong>Content:</strong>
                    <div id="mtp-preview-content-text" class="mtp-preview-text"></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Progress Modal -->
    <div class="mtp-modal" id="mtp-progress-modal" style="display:none;">
        <div class="mtp-modal-content mtp-progress-content">
            <div class="mtp-progress-icon"><span class="dashicons dashicons-translation mtp-spin"></span></div>
            <h3 id="mtp-progress-title">Translating...</h3>
            <div class="mtp-progress-bar">
                <div class="mtp-progress-fill" id="mtp-progress-fill"></div>
            </div>
            <p id="mtp-progress-status">Preparing...</p>
            <p id="mtp-progress-lang" class="mtp-progress-lang"></p>
        </div>
    </div>
    
    <!-- Result Modal -->
    <div class="mtp-modal" id="mtp-result-modal" style="display:none;">
        <div class="mtp-modal-content">
            <span class="mtp-modal-close" id="mtp-close-result">&times;</span>
            <div id="mtp-result-content"></div>
        </div>
    </div>
    
    <p style="margin-top:30px;"><a href="https://mistertranslate.com/#precio" target="_blank" style="font-weight:bold;">🛒 Purchase words here</a></p>
</div>

<?php if ($quick_translate_id): ?>
<script>
jQuery(document).ready(function($) {
    setTimeout(function() {
        var itemId = <?php echo $quick_translate_id; ?>;
        var itemType = '<?php echo esc_js($quick_translate_type); ?>';
        if (itemType === 'page' || itemType === 'post') {
            $('.mtp-load-all[data-type="page"]').trigger('click');
        }
    }, 500);
});
</script>
<?php endif; ?>
