<?php
/**
 * Settings Page - MisterTranslate
 * Secure credential handling
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get credentials securely
$credentials = MTP_Security::get_credentials();
$client_id = $credentials['client_id'];
$has_secret = !empty($credentials['secret_key']);
$has_credentials = !empty($client_id) && $has_secret;

// Show masked secret key if exists
$secret_display = $has_secret ? '••••••••••••••••' : '';
$registered_domain = get_option('mtp_registered_domain', '');
?>
<div class="wrap mtp-settings-wrap">
    <h1>MisterTranslate - Settings</h1>
    
    <?php if (!$has_credentials): ?>
    <div class="mtp-no-account-alert">
        <span class="dashicons dashicons-info"></span>
        <span>Don't have an account yet? <a href="#mtp-create-account">Create one here &rarr;</a></span>
    </div>
    <?php endif; ?>
    
    <form method="post">
        <?php wp_nonce_field('mtp_settings_nonce'); ?>
        <table class="form-table">
            <tr>
                <th><label for="mtp_client_id">Client ID</label></th>
                <td>
                    <input type="text" name="mtp_client_id" id="mtp_client_id" value="<?php echo esc_attr($client_id); ?>" class="regular-text" placeholder="client_xxxxxxxx">
                    <p class="description">Your unique client identifier (starts with client_)</p>
                </td>
            </tr>
            <tr>
                <th><label for="mtp_secret_key">Secret Key</label></th>
                <td>
                    <input type="password" name="mtp_secret_key" id="mtp_secret_key" value="" class="regular-text" placeholder="<?php echo $has_secret ? 'Enter new key to change' : 'Enter your secret key'; ?>">
                    <?php if ($has_secret): ?>
                    <p class="description" style="color: #46b450;"><span class="dashicons dashicons-yes"></span> Secret key is configured and encrypted</p>
                    <?php else: ?>
                    <p class="description">Your secret API key (will be encrypted)</p>
                    <?php endif; ?>
                </td>
            </tr>
        </table>
        
        <?php if ($registered_domain): ?>
        <p class="description" style="margin-top: -10px; margin-bottom: 20px;">
            <span class="dashicons dashicons-admin-site"></span> 
            Registered domain: <strong><?php echo esc_html($registered_domain); ?></strong>
        </p>
        <?php endif; ?>
        
        <p class="submit">
            <input type="submit" name="mtp_save_settings" class="button button-primary" value="Save">
            <button type="button" class="button" id="mtp-test-connection" style="margin-left:10px;">Test Connection</button>
        </p>
    </form>
    
    <div id="mtp-test-result" style="display:none;margin-top:15px;"></div>
    
    <hr>
    
    <!-- How to Buy Words Section -->
    <div id="mtp-how-to-buy" class="mtp-instructions-section">
        <h2><span class="dashicons dashicons-cart"></span> How to Purchase Words</h2>
        <div class="mtp-instructions-box">
            <ol class="mtp-steps-list">
                <li>
                    <strong>Visit the store</strong><br>
                    Go to <a href="https://mistertranslate.com" target="_blank">mistertranslate.com</a>
                </li>
                <li>
                    <strong>Browse available packages</strong><br>
                    Scroll down to view the available products and pricing options
                </li>
                <li>
                    <strong>Complete your purchase</strong><br>
                    Select the word package that suits your needs and proceed to checkout
                </li>
                <li>
                    <strong>Start translating</strong><br>
                    Once your purchase is complete, the words will be added to your account and you can begin translating immediately
                </li>
            </ol>
            <p class="mtp-instructions-note">
                <span class="dashicons dashicons-info-outline"></span>
                <em>If you don't have an account yet, please follow the instructions below to create one first.</em>
            </p>
        </div>
    </div>
    
    <hr>
    
    <!-- How to Create Account Section -->
    <div id="mtp-create-account" class="mtp-instructions-section">
        <h2><span class="dashicons dashicons-admin-users"></span> How to Create an Account</h2>
        <div class="mtp-instructions-box">
            <ol class="mtp-steps-list">
                <li>
                    <strong>Visit the website</strong><br>
                    Go to <a href="https://mistertranslate.com" target="_blank">mistertranslate.com</a>
                </li>
                <li>
                    <strong>Access registration</strong><br>
                    Navigate to the <a href="https://mistertranslate.com/registro/" target="_blank">registration page</a>
                </li>
                <li>
                    <strong>Enter your details</strong><br>
                    Fill in your registration information and submit the form
                </li>
                <li>
                    <strong>Retrieve your credentials</strong><br>
                    You will receive an email containing your unique <strong>Client ID</strong> and <strong>Secret Key</strong>
                </li>
                <li>
                    <strong>Configure the plugin</strong><br>
                    Enter your Client ID and Secret Key in the fields at the top of this page and click "Save"
                </li>
            </ol>
            <p class="mtp-instructions-cta">
                <a href="https://mistertranslate.com/registro/" target="_blank" class="button button-primary">
                    <span class="dashicons dashicons-external"></span> Create Account Now
                </a>
            </p>
        </div>
    </div>
    
    <hr>
    
    <!-- Notification Settings Section -->
    <div id="mtp-notifications" class="mtp-instructions-section">
        <h2><span class="dashicons dashicons-email-alt"></span> Notification Settings</h2>
        <form method="post">
            <?php wp_nonce_field('mtp_settings_nonce'); ?>
            <?php 
            $notification_settings = MTP_Notifications::get_settings();
            ?>
            <div class="mtp-notification-settings">
                <table class="form-table">
                    <tr>
                        <th><label for="mtp_low_balance_enabled">Low Balance Alerts</label></th>
                        <td>
                            <label>
                                <input type="checkbox" name="mtp_low_balance_enabled" id="mtp_low_balance_enabled" value="1" <?php checked($notification_settings['low_balance_enabled']); ?>>
                                Send email when balance is low
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="mtp_low_balance_threshold">Alert Threshold</label></th>
                        <td>
                            <input type="number" name="mtp_low_balance_threshold" id="mtp_low_balance_threshold" value="<?php echo esc_attr($notification_settings['low_balance_threshold']); ?>" class="small-text" min="100" step="100">
                            <span class="description">tokens (default: 1000)</span>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="mtp_notification_email">Notification Email</label></th>
                        <td>
                            <input type="email" name="mtp_notification_email" id="mtp_notification_email" value="<?php echo esc_attr($notification_settings['notification_email']); ?>" class="regular-text">
                            <p class="description">Email address for low balance alerts</p>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <input type="submit" name="mtp_save_notifications" class="button button-secondary" value="Save Notification Settings">
                </p>
            </div>
        </form>
    </div>
    
    <hr>
    
    <h2>Supported Page Builders</h2>
    <ul>
        <li><strong>Elementor</strong> - Automatically detects pages with _elementor_data</li>
        <li><strong>Avia/Enfold</strong> - Automatically detects pages with _aviaLayoutBuilderCleanData</li>
        <li><strong>Standard WordPress</strong> - For pages without a page builder</li>
    </ul>
    <p>The plugin automatically detects which builder each page uses and routes the content to the appropriate handler.</p>
    
    <hr>
    <p style="margin-top:15px;"><a href="https://mistertranslate.com/#precio" target="_blank" style="font-weight:bold;">🛒 Purchase words here</a></p>
</div>

<script>
jQuery(document).ready(function($) {
    $('#mtp-test-connection').on('click', function() {
        var $btn = $(this), $result = $('#mtp-test-result');
        $btn.prop('disabled', true).text('Testing...');
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: { action: 'mtp_check_balance', nonce: '<?php echo wp_create_nonce('mtp_nonce'); ?>' },
            success: function(r) {
                $result.html(r.success 
                    ? '<div class="notice notice-success"><p>✓ Connected! Tokens: ' + r.data.tokens_remaining.toLocaleString() + '</p></div>'
                    : '<div class="notice notice-error"><p>✗ ' + r.data + '</p></div>'
                ).show();
            },
            error: function() { $result.html('<div class="notice notice-error"><p>✗ Network error</p></div>').show(); },
            complete: function() { $btn.prop('disabled', false).text('Test Connection'); }
        });
    });
    
    $('a[href^="#"]').on('click', function(e) {
        var target = $(this.hash);
        if (target.length) {
            e.preventDefault();
            $('html, body').animate({ scrollTop: target.offset().top - 50 }, 400);
            target.addClass('mtp-highlight');
            setTimeout(function() { target.removeClass('mtp-highlight'); }, 1500);
        }
    });
});
</script>
